<?php

/**
 * Plugin Name:       xCloud Migration Assistant
 * Plugin URI:        https://xcloud.host
 * Description:       Move your WordPress site into xCloud with a few clicks!
 * Version:           0.4.7
 * Requires at least: 5.2
 * Requires PHP:      7.0
 * Author:            xCloud
 * Author URI:        https://xcloud.host
 */

use xCloud\MigrationAssistant\Encrypter;

// use xCloud\MigrationAssistant\ReceiveProcessingStatuses;
use xCloud\MigrationAssistant\Rest;
use xCloud\MigrationAssistant\Settings;
use xCloud\MigrationAssistant\xCloudOption;

class xCloudMigrationAssistant
{
    const XCLOUD_BYTE_PER_REQUEST = 1025 * 500;

    const ENCRYPTION_CIPHER = 'AES-256-CBC';

    const PLUGIN_SLUG = 'xcloud-migration-assistant';

    private static $instance = null;

    public $container = [];

    public function __construct()
    {

    }

    public static function getInstance()
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function includeFiles()
    {
        require_once __DIR__.'/src/Encrypter.php';
        require_once __DIR__.'/src/Settings.php';
        require_once __DIR__.'/src/Rest.php';
        require_once __DIR__.'/src/Response.php';
        require_once __DIR__.'/src/FileSystemMigration.php';
        require_once __DIR__.'/src/FileCompressor.php';
        require_once __DIR__.'/src/DatabaseMigration.php';
        require_once __DIR__.'/src/xCloudOption.php';
        require_once __DIR__.'/helpers/functions.php';

        if (defined('WP_CLI')) {
            require_once __DIR__.'/src/WpCli.php';
        }
    }

    public function init()
    {
        $this->includeFiles();

        $this->container['settings'] = new Settings();
        $this->container['rest'] = new Rest();
    }

    static function getOption($key)
    {
        return xCloudOption::get('settings.'.$key);
    }

    static function get($array, $key)
    {
        return isset($array[$key]) ? $array[$key] : null;
    }

    public function getVersion()
    {
        if (!function_exists('get_plugin_data')) {
            require_once(ABSPATH.'wp-admin/includes/plugin.php');
        }

        $plugin_data = get_plugin_data(__FILE__);

        return isset($plugin_data['Version']) ? $plugin_data['Version'] : null;
    }
}

function xcloud_migration()
{
    return xCloudMigrationAssistant::getInstance();
}

xcloud_migration()->init();
