<?php

namespace xCloud\MigrationAssistant;

use WP_CLI;
use Exception;
use WP_CLI\CommandWithMeta;
use WP_CLI\Utils;

class Token_Command extends CommandWithMeta
{
    public function __invoke($args, $assoc_args)
    {
        $token = isset($args[0]) ? $args[0] : null;

        if (!$token) {
            WP_CLI::error("Migration token is required");
            return;
        }

        $key = substr($token, 0, 32);
        $actualToken = substr($token, 32);

        try {
            $decodedToken = json_decode((new Encrypter($key))->decrypt($actualToken), true);

            xCloudOption::set('settings', [
                'token' => $token,
                'auth_token' => xcloud_migration()->get($decodedToken, 'auth_token'),
                'encryption_key' => xcloud_migration()->get($decodedToken, 'encryption_key'),
                'site_id' => xcloud_migration()->get($decodedToken, 'site_id'),
            ]);

            WP_CLI::success("Token has been verified successfully. You can now run the migration.");

        } catch (Exception $e) {
            WP_CLI::error($e->getMessage());
            return;
        }
    }
}

WP_CLI::add_command('xcloud-set-migration-token', Token_Command::class, [
    'shortdesc' => 'Set xcloud migration token',
    'synopsis' => '<token>'
]);
