<?php

namespace xCloud\MigrationAssistant;

use Exception;
use PharData;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use RuntimeException;
use WP_Error;
use ZipArchive;

class FileCompressor
{
    private $dir;
    private $zipPath;

    public function __construct() // $dir, $zipPath
    {
        // $this->dir = $dir;
        // $this->zipPath = $zipPath;
    }

    function zipDirectory($sourcePath, $outZipPath, $cleanFolder = false)
    {
        if (!class_exists('ZipArchive')) {
            try {
                $phar = new PharData($outZipPath);

                if (is_dir($sourcePath)) {
                    $phar->buildFromDirectory($sourcePath);
                } elseif (is_file($sourcePath)) {
                    $phar->addFile($sourcePath, basename($sourcePath));
                }
                return true;
            } catch (Exception $e) {
                throw new RuntimeException("Could not create archive: ".$e->getMessage());
            }
        }

        $zip = new ZipArchive();

        if (file_exists($outZipPath)) {
            unlink($outZipPath);
        }

        if (!is_dir($outZipPath)) {
            @mkdir(dirname($outZipPath), 0777, true);
        }

        // clean folder
        // but ensure it is outside wp-content/xcloud-migration
        if ($cleanFolder && preg_match('/^'.preg_quote(rtrim(ABSPATH, '/').'/wp-content/xcloud-migration', '/').'/', $outZipPath)) {
            foreach (glob(dirname($outZipPath).'/*', GLOB_NOSORT) as $file) {
                if (is_file($file)) {
                    unlink($file);
                }
            }
        }

        // ensure it has .htaccess file containing Options -Indexes
        $htaccessPath = dirname($outZipPath).'/.htaccess';

        if (!file_exists($htaccessPath)) {
            file_put_contents($htaccessPath, 'Options -Indexes');
        }

        $result = $zip->open($outZipPath, ZipArchive::CREATE);

        if ($result !== true) {
            throw new RuntimeException('Cannot open file for writing: '.$outZipPath);
        }

        $sourcePath = realpath($sourcePath);

        if (is_dir($sourcePath) === true) {
            $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($sourcePath), RecursiveIteratorIterator::SELF_FIRST);

            foreach ($files as $file) {
                $file = realpath($file);

                if (is_dir($file) === true) {
                    $zip->addEmptyDir(str_replace($sourcePath.'/', '', $file.'/'));
                } else {
                    if (is_file($file) === true) {
                        $zip->addFile($file, str_replace($sourcePath.'/', '', $file));
                    }
                }
            }
        } else {
            if (is_file($sourcePath) === true) {
                $zip->addFile($sourcePath, basename($sourcePath));
            }
        }

        return $zip->close();
    }

    static function getFolderSize($dir)
    {
        $size = 0;

        foreach (glob(rtrim($dir, '/').'/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : self::getFolderSize($each);
        }

        return $size;
    }

    static function getFolderSizeAndCount($dir)
    {
        $size = 0;
        $fileCount = 0;

        foreach (glob(rtrim($dir, '/').'/*', GLOB_NOSORT) as $each) {
            if (is_file($each)) {
                $size += filesize($each);
                $fileCount++;
            } else {
                list($dirSize, $dirCount) = self::getFolderSizeAndCount($each);
                $size += $dirSize;
                $fileCount += $dirCount;
            }
        }

        return array($size, $fileCount);
    }
}