<?php

function xCloudFindTaskByTaskId($arr, $taskIndex, $subArrayKey = 'tasks')
{
    $arr = json_decode(json_encode($arr), true);

    if (empty($arr)) {
        return [];
    }

    foreach ($arr as $i => $elements) {

        foreach ($elements as $key => $element) {

            if ($key == $subArrayKey) {

                foreach ($element as $index => $value) {

                    if ($index == $taskIndex) {

                        return array_merge($arr[$i], ['task_index_id' => $i]);
                    }
                }
            }
        }

    }

    return [
        'stage' => 'Not initialized',
        'tasks' => [
            [
                'Pending',
            ]
        ]
    ];
}

function xCloudFindArrayValuesByKeys($array = [], $key = 'stage')
{
    $array = json_decode(json_encode($array), true);

    $value = [];

    if (empty($array)) {
        return [];
    }

    foreach ($array as $i => $elements) {
        $value[] = $elements[$key];
    }

    return $value;
}

function xcloud_migration_get_server_memory_limit()
{
    $memoryLimit = ini_get('memory_limit');

    if (preg_match('/^(\d+)(.)$/', $memoryLimit, $matches)) {
        if ($matches[2] == 'M') {
            $memoryLimit = $matches[1] * 1024 * 1024; // convert to bytes
        } else {
            if ($matches[2] == 'K') {
                $memoryLimit = $matches[1] * 1024; // convert to bytes
            } else {
                if ($matches[2] == 'G') {
                    $memoryLimit = $matches[1] * 1024 * 1024 * 1024; // convert to bytes
                }
            }
        }
    }

    $availableMemory = $memoryLimit - ($memoryLimit * 0.20);
    $feeDiskSpace = disk_free_space(ABSPATH);
    $availableStorage = $feeDiskSpace - ($feeDiskSpace * 0.20);

    return min($availableMemory, $availableStorage);
}


function xcloud_migration_log()
{
    $logs = func_get_args();

    error_log(count($logs) == 1 ? $logs[0] : print_r(func_get_args(), true));
}


function insert_http($url)
{
    if (!preg_match("~^(?:f|ht)tps?://~i", $url)) {
        $url = "http://".$url;
    }
    return $url;
}