<?php

namespace WilokeTeamMember\Controllers;


use WilokeTeamMember\Controllers\PostControl\CustomPostControl;
use WilokeTeamMember\Controllers\ProductControl\ProductControl;
use WilokeTeamMember\Share\App;

class RegistrationController
{
	public static string $WilokeTeamMember = 'WilokeTeamMember';

	public function __construct()
	{
		add_filter('elementor/frontend/print_google_fonts', '__return_false');
		$aConfigs = json_decode(file_get_contents(plugin_dir_path(__FILE__) . '../Configs/config.json'), true);
		App::bind('dataConfig', $aConfigs);
		add_action('elementor/elements/categories_registered', [$this, 'registerCategories']);
		add_action('elementor/widgets/register', [$this, 'registerAddon']);
		add_action('elementor/controls/register', [$this, 'registerControls']);
		add_action('wp_enqueue_scripts', [$this, 'registerScripts']);
	}

	public function registerCategories($oElementsManager)
	{
		$key = App::get('dataConfig')['category']['key'] ?? 'wiloke-category';
		if (!array_key_exists($key, $oElementsManager->get_categories())) {
			$oElementsManager->add_category(
				$key,
				[
					'title' => App::get('dataConfig')['category']['title'] ??
						esc_html__('Wiloke', 'wil-team-member'),
					'icon'  => App::get('dataConfig')['category']['icon'] ?? 'eicon-font',
				]
			);
		}
	}

	public function registerScripts()
	{
		$aHandleCss = [];
		$aHandleJs = [];
		wp_register_style(
			WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5(App::get('dataConfig')['css']),
			App::get('dataConfig')['css'],
			[],
			WILOKE_WILOKETEAMMEMBER_VERSION);

		$aHandleCss[] = WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5(App::get('dataConfig')['css']);

		wp_register_script(
			WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5(App::get('dataConfig')['js']),
			App::get('dataConfig')['js'],
			['elementor-frontend'],
			WILOKE_WILOKETEAMMEMBER_VERSION,
			true
		);
		$aHandleJs[] = WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5(App::get('dataConfig')['js']);
		if (isset(App::get('dataConfig')['libs']['css']) && !empty($aLibCss = App::get('dataConfig')['libs']['css'])) {
			foreach ($aLibCss as $urlCss) {
				wp_register_style(
					WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5($urlCss),
					$urlCss,
					[], WILOKE_WILOKETEAMMEMBER_VERSION);
				$aHandleCss[] = WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5($urlCss);
			}
		}
		App::bind('handleCss', $aHandleCss);

		if (isset(App::get('dataConfig')['libs']['js']) && !empty($aLibJs = App::get('dataConfig')['libs']['js'])) {
			foreach ($aLibJs as $urlJs) {
				wp_register_script(
					WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5($urlJs),
					$urlJs,
					[],
					WILOKE_WILOKETEAMMEMBER_VERSION,
					true
				);
			}
			$aHandleJs[] = WILOKE_WILOKETEAMMEMBER_NAMESPACE . md5($urlJs);
		}
		App::bind('handleJs', $aHandleJs);
		wp_localize_script('jquery', 'WilokeTeamMember', [
			'prefix' => WILOKE_WILOKETEAMMEMBER_NAMESPACE,
			'userID' => get_current_user_id(),
			'ajaxUrl' => admin_url('admin-ajax.php')
		]);
	}

	public function registerAddon($oWidgetManager)
	{
		$oWidgetManager->register(new PluginAddon());
	}

	public function registerControls($oControlManager)
	{
		
		
	}
}