<?php

namespace WilokeTeamMember\Controllers\ProductControl;

use Elementor\Base_Control;
use WilokeTeamMember\Share\TraitHandleCustomProduct;

class ProductControl extends Base_Control
{
	use TraitHandleCustomProduct;

	public function getFieldsOrderBy(): array
	{
		return [
			'ID'            => esc_attr__('ID', 'wil-team-member'),
			'author'        => esc_attr__('Author', 'wil-team-member'),
			'title'         => esc_attr__('Title', 'wil-team-member'),
			'date'          => esc_attr__('Date', 'wil-team-member'),
			'menu_order'    => esc_attr__('Menu Order', 'wil-team-member'),
			'rand'          => esc_attr__('Random', 'wil-team-member'),
			'comment_count' => esc_attr__('Comment Count', 'wil-team-member'),
		];
	}

	public function getFieldsOrder(): array
	{
		return [
			'desc' => esc_attr__('DESC', 'wil-team-member'),
			'asc'  => esc_attr__('ASC', 'wil-team-member')
		];
	}

	public function getFieldsFilterProduct(): array
	{
		return [
			'onSale'     => esc_attr__('On Sale', 'wil-team-member'),
			'outOfStock' => esc_attr__('Out Of Stock', 'wil-team-member'),
			'inStock'    => esc_attr__('In Stock', 'wil-team-member'),
			'categories' => esc_attr__('Categories', 'wil-team-member'),
			'tags'       => esc_attr__('Tags', 'wil-team-member')
		];
	}

	public function get_type()
	{
		return 'wil-product';
	}

	public function enqueue()
	{
		wp_register_script(WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_product_script',
			WILOKE_WILOKETEAMMEMBER_VIEWS_URL . 'src/Controllers/ProductControl/ProductControl.js',
			['jquery'],
			WILOKE_WILOKETEAMMEMBER_VERSION,
			true);
		wp_localize_script('jquery', 'WilokeTeamMember', [
			'prefix' => WILOKE_WILOKETEAMMEMBER_NAMESPACE
		]);
		wp_enqueue_script(WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_product_script');
	}

	public function content_template()
	{
		$postID = (int)$_GET['post'];
		$aData = $this->getFieldsProductData($postID);
		$orderBy = $aData['orderBy'] ?? "{{{data.default.orderby}}}" ?? 'ID';
		$order = $aData['order'] ?? "{{{data.default.order}}}" ?? 'desc';
		$productFilter = $aData['productFilter'] ?? "{{{data.default.filter}}}" ?? 'onSale';
		$postNumber = $aData['postNumber'] ?? "{{{data.default.limit}}}" ?? 20;
		$aCategories = [];
		if (isset($aData['productCategories']) && !empty($aData['productCategories'])) {
			foreach ($aData['productCategories'] as $rawCategoryID) {
				$categoryID = (int)$rawCategoryID;
				$oTag = get_term($categoryID, 'product_cat');
				$aCategories[$categoryID] = $oTag->name;
			}
		}
		$aTags = [];
		if (isset($aData['productTags']) && !empty($aData['productTags'])) {

			foreach ($aData['productTags'] as $rawTagId) {
				$tagId = (int)$rawTagId;
				$oTag = get_term($tagId, 'product_tag');
				$aTags[$tagId] = $oTag->name;
			}
		}
		?>

        <div class="elementor-control elementor-control-type-divider elementor-label-inline elementor-control-separator-none">
            <div class="elementor-control-content">
            </div>
        </div>
        <label for="elementor-control-default-c1218" class="elementor-control-title wil-margin-bottom-15">
            {{{ data.label }}}
        </label>

        <# if ( data.description ) { #>
        <div class="elementor-control-field-description">{{{ data.description }}}</div>
        <# } #>
        <div class="elementor-control-field wil-margin-bottom-15">
            <input id="wil-product-id" type="hidden" name="wilPostId"
                   value="<?php echo esc_attr($_GET['post'] ?? 0); ?>">
            <label class="elementor-control-title"><?php echo esc_html__('Product Filter','wil-team-member') ?></label>

            <div class="elementor-control-input-wrapper wil-width-100 elementor-control-unit-5">
                <select id="wil-filter-product" name="wil-filter-product">
					<?php foreach ($this->getFieldsFilterProduct() as $key => $value): ?>
                        <option <?php echo esc_attr($key == $productFilter ? 'selected' : ''); ?>
                                value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
					<?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="<?php echo esc_attr($productFilter != 'categories' ? 'wil-hidden' : ''); ?>
        elementor-control-field wil-margin-bottom-15"
             id="wil-categories-product-hidden">

            <label class="elementor-control-title"><?php echo esc_html__('Categories Product', 'wil-team-member');
            ?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5 wil-margin-bottom">
                <select multiple
                        class="post-select wil-width-100"
                        name="wil-product-categories"
                        id="wil-product-categories-ids">
					<?php
					if (!empty($aCategories)) {
						foreach ($aCategories as $key => $name):?>
                            <option value="<?php echo esc_attr($key); ?>" selected="selected">
								<?php echo esc_attr($name); ?>
                            </option>
						<?php
						endforeach;
					}
					?>
                </select>
            </div>
        </div>

        <div class="<?php echo esc_attr($productFilter != 'tags' ? 'wil-hidden' :
			'') ?> elementor-control-field wil-margin-bottom-15"
             id="wil-tag-product-hidden">
            <label class="elementor-control-title"><?php echo esc_html__('Tags Product', 'wil-team-member'); ?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5">
                <select multiple class="post-select wil-width-100" name="wil-product-tags" id="wil-product-tags-ids">
					<?php
					if (!empty($aTags)) {
						foreach ($aTags as $key => $name):
							?>
                            <option value="<?php echo esc_attr($key); ?>" selected="selected">
								<?php echo esc_html($name); ?>
                            </option>
						<?php
						endforeach;
					}
					?>
                </select>
            </div>
        </div>

        <div class="elementor-control-field wil-margin-bottom">

            <label for="elementor-control-default-c1218"
                   class="elementor-control-title"><?php echo esc_html__('Number Products', 'wil-team-member'); ?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5 wil-width-100">
                <input id="wil-products-number"
                       type="number"
                       name="productsNumber"
                       value="<?php echo esc_attr($postNumber); ?>">
            </div>
        </div>
        <br>
        <div class="elementor-control-field">

            <label class="elementor-control-title"><?php echo esc_html__('Order By', 'wil-team-member'); ?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5">
                <select class="wil-width-100" id="wil-product-order-by" name="wil-product-order-by">
					<?php foreach ($this->getFieldsOrderBy() as $key => $value): ?>
                        <option <?php echo esc_attr($key == $orderBy ? 'selected' : ''); ?>
                                value="<?php echo esc_attr($key); ?>">
							<?php echo esc_attr($value); ?>
                        </option>
					<?php endforeach; ?>
                </select>
            </div>
        </div>
        <br>
        <div class="elementor-control-field">

            <label class="elementor-control-title"><?php echo esc_html__('Order','wil-team-member')?></label>

            <div class="elementor-control-input-wrapper elementor-control-unit-5">
                <select class="wil-width-100" id="wil-product-order" name="wil-product-order">
					<?php foreach ($this->getFieldsOrder() as $key => $value): ?>
                        <option <?php echo esc_attr($key == $order ? 'selected' : ''); ?>
                                value="<?php echo esc_attr($key); ?>">
							<?php echo esc_attr($value); ?>
                        </option>
					<?php endforeach; ?>
                </select>
            </div>
        </div>
        <br>
        <div class="elementor-control elementor-control-type-divider elementor-label-inline elementor-control-separator-none">
            <div class="elementor-control-content">
            </div>
        </div>

		<?php

	}
}