<?php

namespace WilokeTeamMember\Controllers;

use Exception;
use WilokeTeamMember\Share\TraitHandleCustomPost;
use WilokeTeamMember\Share\TraitHandleCustomProduct;
use WilokeTeamMember\Share\TraitHandleQuery;

class HandleAjaxController
{
	use TraitHandleCustomPost, TraitHandleQuery, TraitHandleCustomProduct;

	public function __construct()
	{
		add_action('wp_ajax_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_post',
			[$this, 'ajaxCustomWilPost']);
		add_action('wp_ajax_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_product_categories',
			[$this, 'ajaxCustomWilProductCategories']);
		add_action('wp_ajax_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_product_tags',
			[$this, 'ajaxCustomWilProductTags']);
		add_action('wp_ajax_nopriv_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_product_categories',
			[$this, 'ajaxCustomWilProductCategories']);
		add_action('wp_ajax_nopriv_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_product_tags',
			[$this, 'ajaxCustomWilProductTags']);
		add_action('wp_ajax_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_post_save_value',
			[$this, 'ajaxCustomWilPostSaveValue']);
		add_action('wp_ajax_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_product_save_value',
			[$this, 'ajaxCustomWilProductSaveValue']);
		add_action('wp_ajax_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_product_delete_value',
			[$this, 'ajaxCustomWilProductDeleteValue']);
		add_action('wp_ajax_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_custom_wil_post_delete_value',
			[$this, 'ajaxCustomWilPostDeleteValue']);
		add_action('wp_ajax_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_check_products_wishlist',
			[$this, 'ajaxCheckListProductsIsWishList']);
		add_action('wp_ajax_nopriv_' . WILOKE_WILOKETEAMMEMBER_NAMESPACE . '_check_products_wishlist',
			[$this, 'ajaxCheckListProductsIsWishList']);
	}

	public function ajaxCheckListProductsIsWishList()
	{
		try {
			$userID = sanitize_text_field($_POST['userID']);
			if (empty($userID)) {
				throw new Exception(esc_html__('Sorry, The account is not permission',WILOKE_WILOKETEAMMEMBER_NAMESPACE));
			}

			$productIds = sanitize_text_field($_POST['productsId']);
			if (empty($productIds)) {
				throw new Exception(esc_html__('The productsId is required!',WILOKE_WILOKETEAMMEMBER_NAMESPACE));
			}
			$aProductsId = array_map(function ($productId) {
				return (int)$productId;
			}, explode(",", $productIds));
			$aResponseData = [];
			set_current_user($userID);
			foreach ($aProductsId as $productId) {
				$inWishList = false;
				if (function_exists('YITH_WCWL')) {
					$inWishList = YITH_WCWL()->is_product_in_wishlist($productId);
				}
				$aResponseData[$productId] = $inWishList;
			}
			wp_send_json([
				'message' => esc_html__("found it", WILOKE_WILOKETEAMMEMBER_NAMESPACE),
				'status'  => esc_html__('success', WILOKE_WILOKETEAMMEMBER_NAMESPACE),
				'items'   => $aResponseData
			], 200);
			die();
		}
		catch (Exception $exception) {
			wp_send_json([
				'message' => $exception->getMessage(),
				'status'  => esc_html__('error', WILOKE_WILOKETEAMMEMBER_NAMESPACE),
			], $exception->getCode());
			die();
		}
	}

	public function ajaxCustomWilPostDeleteValue()
	{
		$postID = (int)$_POST['payload']['postID'];
		$this->deleteFieldsData($postID);
	}

	public function ajaxCustomWilProductDeleteValue()
	{
		$postID = (int)$_POST['payload']['postID'];
		$this->deleteFieldsProductData($postID);
	}

	public function ajaxCustomWilPost()
	{
		$aArgs = [
			'type'       => 'post',
			'number'     => 50,
			'hide_empty' => 0,
		];
		if (isset($_GET['q'])) {
			$aArgs['search'] = $_GET['q'];
		}
		$aCategories = get_categories($aArgs);
		if (!empty($aCategories)) {
			foreach ($aCategories as $oCategory) {
				$aResponse[] = [
					"id"   => $oCategory->term_id,
					"text" => $oCategory->name,
				];
			}
		}
		wp_send_json($aResponse);
	}

	public function ajaxCustomWilPostSaveValue()
	{
		$aArgs = $_POST['payload'];
		if (isset($aArgs['postID'])) {
			$postID = (int)$aArgs['postID'];
			unset($aArgs['postID']);
			$this->updateFieldsData($postID, $aArgs);
		}
		$aResponse = $this->commonParseArgs($_POST['payload'])->query();
		$aResponse['wil-post'] = true;
		wp_send_json([
			'data' => $aResponse
		]);
	}

	public function ajaxCustomWilProductSaveValue()
	{

		$aArgs = $_POST['payload'];
		if (isset($aArgs['postID'])) {
			$postID = (int)$aArgs['postID'];
			unset($aArgs['postID']);
			$this->updateFieldsProductData($postID, $aArgs);
		}
		$aResponse = $this->commonParseArgs($_POST['payload'])->query('product');
		$aResponse['wil-product'] = true;

		wp_send_json([
			'data' => $aResponse
		]);
	}

	public function ajaxCustomWilProductCategories()
	{
		$categoriesProduct = get_terms(['taxonomy' => 'product_cat']);
		foreach ($categoriesProduct as $oCategory) {
			$response[] = [
				"id"   => $oCategory->term_id,
				"text" => $oCategory->name,
			];
		}
		wp_send_json($response);
	}

	public function ajaxCustomWilProductTags()
	{
		$aResponse = [];
		$categoriesProduct = get_terms(
			[
				'taxonomy'   => 'product_tag',
				'hide_empty' => false
			]
		);
		if (!empty($categoriesProduct)) {
			foreach ($categoriesProduct as $oCategory) {
				$aResponse[] = [
					"id"   => $oCategory->term_id,
					"text" => $oCategory->name,
				];
			}
		}
		wp_send_json($aResponse);
	}

}