import SvgIcon from '@elementor/ui/SvgIcon';
import { useSettings } from '@ea11y/hooks';

function AccessibilityPersonIcon(props) {
	const { iconDesign } = useSettings();
	const strokeColor = `lch(from ${iconDesign?.color || '#fff'} calc((50 - l) * 100) 0 0)`;

	return (
		<SvgIcon
			viewBox="0 0 64 64"
			fill="none"
			fontSize="large"
			sx={{ marginRight: 1 }}
			{...props}
		>
			<circle cx="32" cy="32" r="32" />
			<path
				d="M32 24C32.6904 24 33.25 23.4404 33.25 22.75C33.25 22.0596 32.6904 21.5 32 21.5C31.3096 21.5 30.75 22.0596 30.75 22.75C30.75 23.4404 31.3096 24 32 24Z"
				fill="white"
			/>
			<path
				d="M27 43.25L32 35.75M32 35.75L37 43.25M32 35.75V30.75M32 30.75L39.5 28.25M32 30.75L24.5 28.25M9.5 32C9.5 34.9547 10.082 37.8806 11.2127 40.6104C12.3434 43.3402 14.0008 45.8206 16.0901 47.9099C18.1794 49.9992 20.6598 51.6566 23.3896 52.7873C26.1194 53.918 29.0453 54.5 32 54.5C34.9547 54.5 37.8806 53.918 40.6104 52.7873C43.3402 51.6566 45.8206 49.9992 47.9099 47.9099C49.9992 45.8206 51.6566 43.3402 52.7873 40.6104C53.918 37.8806 54.5 34.9547 54.5 32C54.5 29.0453 53.918 26.1194 52.7873 23.3896C51.6566 20.6598 49.9992 18.1794 47.9099 16.0901C45.8206 14.0008 43.3402 12.3434 40.6104 11.2127C37.8806 10.082 34.9547 9.5 32 9.5C29.0453 9.5 26.1194 10.082 23.3896 11.2127C20.6598 12.3434 18.1794 14.0008 16.0901 16.0901C14.0008 18.1794 12.3434 20.6598 11.2127 23.3896C10.082 26.1194 9.5 29.0453 9.5 32ZM33.25 22.75C33.25 23.4404 32.6904 24 32 24C31.3096 24 30.75 23.4404 30.75 22.75C30.75 22.0596 31.3096 21.5 32 21.5C32.6904 21.5 33.25 22.0596 33.25 22.75Z"
				stroke={strokeColor}
				strokeWidth="3"
				strokeLinecap="round"
				strokeLinejoin="round"
			/>
		</SvgIcon>
	);
}

export default AccessibilityPersonIcon;
