import SvgIcon from '@elementor/ui/SvgIcon';
import { useSettings } from '@ea11y/hooks';

function AccessibilityControlsIcon(props) {
	const { iconDesign } = useSettings();
	const strokeColor = `lch(from ${iconDesign?.color || '#fff'} calc((50 - l) * 100) 0 0)`;
	return (
		<SvgIcon
			viewBox="0 0 64 64"
			fill="none"
			fontSize="large"
			sx={{ marginRight: 1 }}
			{...props}
		>
			<circle cx="32" cy="32" r="32" />
			<path
				d="M31.4998 25.4993C31.4998 26.1182 31.7457 26.7117 32.1833 27.1493C32.6208 27.5869 33.2143 27.8327 33.8332 27.8327C34.452 27.8327 35.0455 27.5869 35.4831 27.1493C35.9207 26.7117 36.1665 26.1182 36.1665 25.4993M31.4998 25.4993C31.4998 24.8805 31.7457 24.287 32.1833 23.8494C32.6208 23.4118 33.2143 23.166 33.8332 23.166C34.452 23.166 35.0455 23.4118 35.4831 23.8494C35.9207 24.287 36.1665 24.8805 36.1665 25.4993M31.4998 25.4993H22.1665M36.1665 25.4993H40.8332M24.4998 32.4993C24.4998 33.1182 24.7457 33.7117 25.1833 34.1493C25.6208 34.5869 26.2143 34.8327 26.8332 34.8327C27.452 34.8327 28.0455 34.5869 28.4831 34.1493C28.9207 33.7117 29.1665 33.1182 29.1665 32.4993M24.4998 32.4993C24.4998 31.8805 24.7457 31.287 25.1833 30.8494C25.6208 30.4118 26.2143 30.166 26.8332 30.166C27.452 30.166 28.0455 30.4118 28.4831 30.8494C28.9207 31.287 29.1665 31.8805 29.1665 32.4993M24.4998 32.4993H22.1665M29.1665 32.4993H40.8332M34.9998 39.4993C34.9998 40.1182 35.2457 40.7117 35.6833 41.1493C36.1208 41.5868 36.7143 41.8327 37.3332 41.8327C37.952 41.8327 38.5455 41.5868 38.9831 41.1493C39.4207 40.7117 39.6665 40.1182 39.6665 39.4993M34.9998 39.4993C34.9998 38.8805 35.2457 38.287 35.6833 37.8494C36.1208 37.4118 36.7143 37.166 37.3332 37.166C37.952 37.166 38.5455 37.4118 38.9831 37.8494C39.4207 38.287 39.6665 38.8805 39.6665 39.4993M34.9998 39.4993H22.1665M39.6665 39.4993H40.8332M9.5 32C9.5 34.9547 10.082 37.8806 11.2127 40.6104C12.3434 43.3402 14.0008 45.8206 16.0901 47.9099C18.1794 49.9992 20.6598 51.6566 23.3896 52.7873C26.1194 53.918 29.0453 54.5 32 54.5C34.9547 54.5 37.8806 53.918 40.6104 52.7873C43.3402 51.6566 45.8206 49.9992 47.9099 47.9099C49.9992 45.8206 51.6566 43.3402 52.7873 40.6104C53.918 37.8806 54.5 34.9547 54.5 32C54.5 29.0453 53.918 26.1194 52.7873 23.3896C51.6566 20.6598 49.9992 18.1794 47.9099 16.0901C45.8206 14.0008 43.3402 12.3434 40.6104 11.2127C37.8806 10.082 34.9547 9.5 32 9.5C29.0453 9.5 26.1194 10.082 23.3896 11.2127C20.6598 12.3434 18.1794 14.0008 16.0901 16.0901C14.0008 18.1794 12.3434 20.6598 11.2127 23.3896C10.082 26.1194 9.5 29.0453 9.5 32Z"
				stroke={strokeColor}
				strokeWidth="3"
				strokeLinecap="round"
				strokeLinejoin="round"
			/>
		</SvgIcon>
	);
}

export default AccessibilityControlsIcon;
