<?php
/*
Plugin Name: Mentor Icon Set
Plugin URI: http://mentoraddons.com/
Description: A Light Weight and Fat Free Elementor Startup Pack.
Version: 1.0
Author: TwinkleTheme
Author URI: http://twinkletheme.xyz/
License: GPLv2 or later
Text Domain: mentor-addons
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'MENTOR_ICON_SET_VERSION', '1.0.0' );
define( 'MENTOR_ICON_SET_ROOT', __FILE__ );
define( 'MENTOR_ICON_SET_PATH', plugin_dir_path( MENTOR_ICON_SET_ROOT ) );
define( 'MENTOR_ICON_SET_URL', plugin_dir_url( MENTOR_ICON_SET_ROOT ) );
define( 'MENTOR_ICON_SET_ASSETS', trailingslashit( MENTOR_ICON_SET_URL . 'assets/' ) );
define( 'MENTOR_ICON_SET_PLUGIN_BASE', plugin_basename( MENTOR_ICON_SET_ROOT ) );

class Mentor_Icon_Set {

    const MINIMUM_ELEMENTOR_VERSION = "2.5.0";
    const MINIMUM_PHP_VERSION = "5.4";

    private static $_instance = null;

    public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;

    }
    
    public function __construct() {
        add_action( 'init', [ $this, 'i18n' ] );
        add_action( 'plugins_loaded', [ $this, 'init' ] );
    }

    public function i18n() {
        load_plugin_textdomain( 'mentor-icon-set' );
    }
    
    public function init() {

        $this->include_files();

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );

			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );

			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );

			return;
		}

    }
    
    public function admin_notice_minimum_php_version() {
        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }

        $message = sprintf(
        /* translators: 1: Plugin name 2: PHP 3: Required PHP version */
            esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'mentor-icon-set' ),
            '<strong>' . esc_html__( 'Mentor Icon Set - Addons for Elementor Page Builder', 'mentor-icon-set' ) . '</strong>',
            '<strong>' . esc_html__( 'PHP', 'mentor-icon-set' ) . '</strong>',
            self::MINIMUM_PHP_VERSION
        );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
    }

    public function admin_notice_minimum_elementor_version() {
        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }

        $message = sprintf(
        /* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
            esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'mentor-icon-set' ),
            '<strong>' . esc_html__( 'Mentor Icon Set - Addons for Elementor Page Builder', 'mentor-icon-set' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'mentor-icon-set' ) . '</strong>',
            self::MINIMUM_ELEMENTOR_VERSION
        );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
    }

    public function admin_notice_missing_main_plugin() {
        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }

        $message = sprintf(
        /* translators: 1: Plugin name 2: Elementor */
            esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'mentor-icon-set' ),
            '<strong>' . esc_html__( 'Mentor Icon Set - Addons for Elementor Page Builder', 'mentor-icon-set' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'mentor-icon-set' ) . '</strong>'
        );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
    }

    public function include_files() {
        include_once( MENTOR_ICON_SET_PATH . ('includes/font-awesone.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/lineicons.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/material-design-icon.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/icofont-icon.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/elementor-icon.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/elegant-icon.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/line-awesome.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/dripicons.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/linearicons.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/rivolicons.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/themify-icons.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/gonzocons.php') );
		include_once( MENTOR_ICON_SET_PATH . ('includes/iconmonstr-icon.php') );
        include_once( MENTOR_ICON_SET_PATH . ('includes/stroke-7.php') );
    }

}

Mentor_Icon_Set::instance();