<?php

namespace GiveRecurring\PaymentGateways\PayPalCommerce\PayPalHttpRequests;

use PayPalHttp\HttpRequest;

/**
 * Class GetSubscription
 *
 * This class uses as request to get a product.
 *
 * @since 2.6.0
 */
class GetSubscription extends HttpRequest
{
    /**
     * CreatePlan constructor.
     *
     * @since 2.6.0
     */
    public function __construct(array $headers, string $paypalSubscriptionId)
    {
        $endpoint = "/v1/billing/subscriptions/$paypalSubscriptionId";
        parent::__construct($endpoint, 'GET');

        $this->headers = array_merge($this->headers, $headers);
    }
}
