<?php

namespace GiveRecurring\LegacySubscription;

use Give\Helpers\Call;
use Give\Helpers\Hooks;
use Give\Subscriptions\Models\Subscription;
use Give\Subscriptions\ValueObjects\SubscriptionStatus;
use GiveRecurring\LegacySubscription\LegacyListeners\DispatchGiveSubscriptionStatus;

/**
 * @since 2.0.0
 */
class ServiceProvider implements \Give\ServiceProviders\ServiceProvider
{

    /**
     * @since 2.0.0
     * @inerhitDoc
     */
    public function register()
    {
    }

    /**
     * @since 2.10.0 Add legacy listeners
     * @since 2.0.0
     * @inerhitDoc
     */
    public function boot()
    {
        add_action('give_init', function () {
            Call::invoke(LegacySubscriptionAdapter::class);
        }, 15);

        $this->addLegacyListeners();
    }

    /**
     * @since 2.10.0
     */
    private function addLegacyListeners()
    {
        add_action('givewp_subscription_updated', function (Subscription $subscription) {
            if ($subscription->isDirty('status')) {
                /** @var SubscriptionStatus $oldStatus */
                $oldStatus = $subscription->getOriginal('status');

                give(DispatchGiveSubscriptionStatus::class)($subscription->id,
                    $subscription->status->getValue(), $oldStatus->getValue());
            }
        });

        Hooks::addAction('give_recurring_update_subscription_status', DispatchGiveSubscriptionStatus::class,
            '__invoke', 10, 3);
    }
}
