<?php

namespace GiveRecurring\LegacySubscription\LegacyListeners;

use Give\Helpers\Hooks;
use Give\Subscriptions\ValueObjects\SubscriptionStatus;
use Give_Subscription;

/**
 * @since 2.10.0
 */
class DispatchGiveSubscriptionStatus
{
    /**
     * @since 2.10.0
     */
    public function __invoke($subscriptionId, $newStatus, $oldStatus)
    {
        if ($newStatus === $oldStatus) {
            return;
        }

        $newStatus = new SubscriptionStatus($newStatus);

        if ($newStatus->isCompleted()) {
            $legacySubscription = new Give_Subscription($subscriptionId);
            Hooks::doAction(
                'give_subscription_completed',
                $legacySubscription->id,
                $legacySubscription
            );
        }

        if ($newStatus->isCancelled()) {
            $legacySubscription = new Give_Subscription($subscriptionId);
            Hooks::doAction(
                'give_subscription_cancelled',
                $legacySubscription->id,
                $legacySubscription
            );
        }
    }
}
