<?php

namespace GiveAuthorizeNet\Webhooks;

use Exception;
use Give\Framework\PaymentGateways\Log\PaymentGatewayLog;
use GiveAuthorizeNet\ValueObjects\WebhooksServerType;
use JohnConde\Authnet\AuthnetApiFactory;

/**
 * @since 2.0.0
 */
class CreateWebhooks
{
    /**
     * @since 2.0.0
     */
    public function __invoke(string $listenerUrl, string $loginId, string $transactionKey, int $server)
    {
        try {
            $request = AuthnetApiFactory::getWebhooksHandler($loginId, $transactionKey, $server);

            $response = $request->createWebhooks([
                'net.authorize.customer.created',
                'net.authorize.customer.deleted',
                'net.authorize.customer.updated',
                'net.authorize.customer.paymentProfile.created',
                'net.authorize.customer.paymentProfile.deleted',
                'net.authorize.customer.paymentProfile.updated',
                'net.authorize.customer.subscription.cancelled',
                'net.authorize.customer.subscription.created',
                'net.authorize.customer.subscription.expired',
                'net.authorize.customer.subscription.expiring',
                'net.authorize.customer.subscription.failed',
                'net.authorize.customer.subscription.suspended',
                'net.authorize.customer.subscription.terminated',
                'net.authorize.customer.subscription.updated',
                'net.authorize.payment.authcapture.created',
                'net.authorize.payment.authorization.created',
                'net.authorize.payment.capture.created',
                'net.authorize.payment.fraud.approved',
                'net.authorize.payment.fraud.declined',
                'net.authorize.payment.fraud.held',
                'net.authorize.payment.priorAuthCapture.created',
                'net.authorize.payment.refund.created',
                'net.authorize.payment.void.created',
            ], $listenerUrl, 'active');

            return $response;
        } catch (Exception $e) {
            PaymentGatewayLog::error(
                '[Authorize.Net] Webhooks were not set up correctly. This is usually caused by the lack of a signature key set up in the Authorize.Net account.',
                [
                    'Code' => $e->getCode(),
                    'Message' => $e->getMessage(),
                ]
            );

            // Common error is not having the signature key setup. Flag notice and only show for live sites.
            if (strpos($e->getMessage(), 'Please generate a signature key') !== false) {
                // Live and sandbox.
                if (WebhooksServerType::PRODUCTION) {
                    give_update_option('give_authorize_live_webhooks_no_signature_key', true);
                } else {
                    give_update_option('give_authorize_sandbox_webhooks_no_signature_key', true);
                }
            }

            return 'error';
        } // End try().
    }
}
