<?php

namespace GiveAuthorizeNet\ValueObjects;

use Give\Framework\Support\ValueObjects\Enum;

/**
 * The overall status of the transaction.
 *
 * @since 2.0.0
 *
 * @method static AuthorizeApiResponseCode APPROVED()
 * @method static AuthorizeApiResponseCode DECLINED()
 * @method static AuthorizeApiResponseCode ERROR()
 * @method static AuthorizeApiResponseCode REVIEW()
 * @method bool isApproved()
 * @method bool isDeclined()
 * @method bool isError()
 * @method bool isReview()
 */
class AuthorizeApiResponseCode extends Enum
{
    const APPROVED = "1";
    const DECLINED = "2";
    const ERROR = "3";
    const REVIEW = "4"; // Not approved through fraud screening. An error with the payment.
}
