<?php

namespace GiveAuthorizeNet\Migrations;

use Give\Framework\Migrations\Contracts\Migration;
use GiveAuthorizeNet\Actions\CreateMerchantPublicClientKey;
use GiveAuthorizeNet\Actions\SendClientPublicKeyUpdateFailedEmail;
use GiveAuthorizeNet\DataTransferObjects\ApiAccessData;
use GiveAuthorizeNet\Exceptions\InvalidCredentialsException;

/**
 * @since 2.0.0
 */
class UpdateLivePublicClientKey extends Migration
{
    /**
     * @inheritdoc
     *
     * @since 2.0.0
     */
    public static function id()
    {
        return 'authorize-update-live-public-client-key';
    }

    /**
     * @inheritdoc
     *
     * @since 2.0.0
     */
    public static function timestamp()
    {
        return strtotime('2022-11-15 02:00:00');
    }

    /**
     * @inheritdoc
     *
     * @since 2.0.0
     *
     * @throws InvalidCredentialsException
     */
    public function run()
    {
        $apiAccessData = ApiAccessData::fromOptions();

        if ($apiAccessData->liveLoginId && $apiAccessData->liveTransactionKey) {
            $clientPublicKey = (new CreateMerchantPublicClientKey())();

            if (empty($clientPublicKey)) {
                (new SendClientPublicKeyUpdateFailedEmail())();
            }
        }
    }
}
