<?php

namespace GiveAuthorizeNet\LegacyListeners;

use Exception;
use Give\Donations\Models\Donation;

/**
 * @since 2.0.3
 */
class DispatchGiveAuthorizeOneTimePaymentDescription
{
    /**
     * @since 2.0.3
     *
     * @throws Exception
     */
    public function __invoke(string $description, Donation $donation): string
    {
        if ( ! has_filter('give_authorize_one_time_payment_description')) {
            return $description;
        }

        $purchase_data = [
            'price' => $donation->amount->formatToDecimal(),
            'purchase_key' => $donation->purchaseKey,
            'user_email' => $donation->donor->email,
            'date' => $donation->createdAt->format('Y-m-d H:i:s'),
            'user_info' => [
                'id' => $donation->donorId,
                'title' => $donation->donor->prefix,
                'email' => $donation->donor->email,
                'first_name' => $donation->donor->firstName,
                'last_name' => $donation->donor->lastName,
                'address' => [
                    'line1' => $donation->billingAddress->address1,
                    'line2' => $donation->billingAddress->address2,
                    'city' => $donation->billingAddress->city,
                    'state' => $donation->billingAddress->state,
                    'zip' => $donation->billingAddress->zip,
                    'country' => $donation->billingAddress->country,
                ],
            ],
            'post_data' => give_clean($_POST),
            'gateway' => $donation->gatewayId,
            'card_info' => [
                'card_name' => '',
                'card_number' => '',
                'card_cvc' => '',
                'card_exp_month' => '',
                'card_exp_year' => '',
                'card_address' => '',
                'card_address_2' => '',
                'card_city' => '',
                'card_state' => '',
                'card_country' => '',
                'card_zip' => '',
            ],
            'gateway_nonce' => '',
        ];

        return apply_filters('give_authorize_one_time_payment_description', $description, $purchase_data);
    }
}
