<?php

namespace GiveAuthorizeNet\Gateway;

use Give\Framework\PaymentGateways\PaymentGateway;
use GiveAuthorizeNet\Exceptions\InvalidCredentialsException;
use GiveAuthorizeNet\Gateway\Traits\CreatePaymentGateway;
use GiveAuthorizeNet\Gateway\Traits\HasScriptAssetFile;
use GiveAuthorizeNet\Gateway\Traits\RefundDonationGateway;

/**
 * @since 2.0.0
 */
class CreditCardGateway extends PaymentGateway
{
    use CreatePaymentGateway;
    use RefundDonationGateway;
    use HasScriptAssetFile;

    /**
     * @since 2.0.0
     *
     *
     * @throws InvalidCredentialsException
     */
    public function getLegacyFormFieldMarkup(int $formId, array $args): string
    {
        ob_start();

        AcceptJs::loadScript($formId);

        if ( ! give_is_setting_enabled(give_get_option('authorize_collect_billing'))) {
            remove_action('give_after_cc_fields', 'give_default_cc_address_fields');
        }

        give_get_cc_form($formId);

        $ccForm = ob_get_clean();

        return $ccForm;
    }

    /**
     * @since 2.0.0
     *
     * @inheritDoc
     */
    public static function id(): string
    {
        return 'authorize';
    }

    /**
     * @since 2.0.0
     *
     * @inheritDoc
     */
    public function getId(): string
    {
        return self::id();
    }

    /**
     * @since 2.0.0
     *
     * @inheritDoc
     */
    public function getName(): string
    {
        return __('Authorize.Net - Credit Card', 'give-authorize');
    }

    /**
     * @since 2.0.0
     *
     * @inheritDoc
     */
    public function getPaymentMethodLabel(): string
    {
        return __('Authorize.Net - Credit Card', 'give-authorize');
    }

    /**
     * @since 3.0
     * @throws InvalidCredentialsException
     */
    public function formSettings(int $formId): array
    {
        return AcceptJs::getApiAccessData();
    }

    /**
     * @since 3.0
     */
    public function enqueueScript(int $formId)
    {
        $assets = $this->getScriptAsset( trailingslashit( GIVE_AUTHORIZE_PLUGIN_DIR ) . '/build/creditCardGateway.asset.php' );

        wp_enqueue_script(
            self::id(),
            trailingslashit( GIVE_AUTHORIZE_PLUGIN_URL ) . 'build/creditCardGateway.js',
            $assets['dependencies'],
            $assets['version'],
            true
        );
    }
}
