<?php

namespace GiveAuthorizeNet\EventHandlers;

use Give\Donations\Models\DonationNote;
use Give\Donations\Repositories\DonationRepository;
use Give\Donations\ValueObjects\DonationStatus;
use Give\Framework\Exceptions\Primitives\Exception;
use Give\Framework\PaymentGateways\Log\PaymentGatewayLog;

/**
 * @since 2.0.0
 */
class DonationFailed
{
    /**
     * @since 2.0.5 Remove wp_die() to prevent failed status on Action Scheduler
     * @since      2.0.0
     * @throws Exception
     */
    public function setStatus(string $gatewayTransactionId, string $message = '')
    {
        $donation = give(DonationRepository::class)->getByGatewayTransactionId($gatewayTransactionId);

        if ($donation) {
            $donation->status = DonationStatus::FAILED();
            $donation->save();

            if (empty($message)) {
                $message = __('Transaction Failed.', 'give-authorize');
            }

            DonationNote::create([
                'donationId' => $donation->id,
                'content' => $message . ' ' . sprintf(__('Authorize transaction ID: %s', 'give-authorize'),
                        $donation->gatewayTransactionId
                    ),
            ]);

            PaymentGatewayLog::error($message . ' ' . sprintf('Donation ID: %s.',
                    $donation->id),
                [
                    'Payment Gateway' => $donation->gateway()->getId(),
                    'Gateway Transaction Id' => $donation->gatewayTransactionId,
                    'Donation' => $donation->id,
                ]
            );
        }
    }
}
