<?php

namespace GiveAuthorizeNet\EventHandlers;

use Give\Donations\Models\DonationNote;
use Give\Donations\ValueObjects\DonationStatus;
use Give\Framework\Exceptions\Primitives\Exception;
use Give\Framework\PaymentGateways\Log\PaymentGatewayLog;

/**
 * @since 2.0.0
 */
class DonationCompleted
{
    /**
     * @since 3.0 Check if the donation is single before changing the status to "complete"
     * @since      2.0.5 Remove wp_die() to prevent failed status on Action Scheduler
     * @since      2.0.0
     *
     * @throws Exception
     */
    public function setStatus(string $gatewayTransactionId, string $message = '')
    {
        $donation = give()->donations->getByGatewayTransactionId($gatewayTransactionId);

        // Subscriptions and renewals are handled in the Recurring addon.
        if ($donation && $donation->type->isSingle() && ! $donation->status->isComplete()) {
            $donation->status = DonationStatus::COMPLETE();
            $donation->save();

            if (empty($message)) {
                $message = __('Transaction Completed.', 'give-authorize');
            }

            DonationNote::create([
                'donationId' => $donation->id,
                'content' => $message . ' ' . sprintf(__('Authorize transaction ID: %s', 'give-authorize'),
                        $donation->gatewayTransactionId
                    ),
            ]);

            PaymentGatewayLog::success(
                $message . ' ' . sprintf('Donation ID: %s.', $donation->id),
                [
                    'Payment Gateway' => $donation->gateway()->getId(),
                    'Gateway Transaction Id' => $donation->gatewayTransactionId,
                    'Donation' => $donation->id,
                ]
            );
        }
    }
}
