<?php

namespace GiveAuthorizeNet\DataTransferObjects;

use GiveAuthorizeNet\ValueObjects\AuthorizeApiResponseCode;

/**
 * @since 2.0.0
 *
 * @see https://developer.authorize.net/api/reference/index.html#accept-suite-create-an-accept-payment-transaction
 */
class AuthorizeTransactionResponse
{

    /**
     * The Authorize.net assigned identification number for a transaction.
     *
     * Use this value to reference at a later time the transaction generated
     * by this API call. You may need the transaction ID for follow-on transactions
     * such as credits, voids, and captures of unsettled transactions, as well as for reporting calls.
     *
     * @var string
     */
    public $transId;

    /**
     *
     * The overall status of the transaction.
     *
     * 1 -- Approved | 2 -- Declined | 3 -- Error | 4 -- Held for Review
     *
     * @var AuthorizeApiResponseCode
     */
    public $responseCode;

    /**
     * @since 2.0.0
     *
     * @param array $data {responseCode: string, transId: string}
     */
    public static function fromArray(array $data): AuthorizeTransactionResponse
    {
        $self = new self();

        $self->responseCode = $data['responseCode'] ?? '';
        $self->transId = $data['transId'] ?? '';

        return $self;
    }
}
