<?php

namespace GiveAuthorizeNet\DataTransferObjects;

use function give_get_option;

/**
 * @since 2.0.0 Handle live and sandbox client public key
 * @since      1.5.0
 */
class ApiAccessData
{
    /**
     * @var string
     */
    public $liveLoginId;
    /**
     * @var string
     */
    public $liveTransactionKey;
    /**
     * @var string
     */
    public $liveClientPublicKey;
    /**
     * @var bool
     */
    public $liveWebhooksSetup;
    /**
     * @var string
     */
    public $sandboxLoginId;
    /**
     * @var string
     */
    public $sandboxTransactionKey;
    /**
     * @var string
     */
    public $sandboxClientPublicKey;
    /**
     * @var bool
     */
    public $sandboxWebhooksSetup;

    public static function fromOptions()
    {
        $instance = new static();

        $instance->liveLoginId = give_get_option('give_api_login', '');
        $instance->liveTransactionKey = give_get_option('give_transaction_key', '');
        $instance->liveClientPublicKey = give_get_option('give_authorize_public_client_key', '');
        $instance->liveWebhooksSetup = give_get_option('give_authorize_live_webhooks_setup', false);

        $instance->sandboxLoginId = give_get_option('give_authorize_sandbox_api_login', '');
        $instance->sandboxTransactionKey = give_get_option('give_authorize_sandbox_transaction_key', '');
        $instance->sandboxClientPublicKey = give_get_option('give_authorize_sandbox_public_client_key', '');
        $instance->sandboxWebhooksSetup = give_get_option('give_authorize_sandbox_webhooks_setup', false);

        return $instance;
    }

}
