<?php

namespace GiveAuthorizeNet\Admin;

use GiveAuthorizeNet\DataTransferObjects\ApiAccessData;

/**
 * @since 2.0.0
 */
class Notices
{
    /**
     * @since 2.0.0
     */
    public function MissingClientPublicKey()
    {
        $apiAccessData = ApiAccessData::fromOptions();

        $notice = [
            'id' => 'give-authorize-missing-client-public-key',
            'type' => 'error',
            'description' => '',
            'dismissible' => false,
        ];

        if (give_is_test_mode() &&
            $apiAccessData->sandboxLoginId &&
            $apiAccessData->sandboxTransactionKey &&
            empty($apiAccessData->sandboxClientPublicKey)) {
            $notice['description'] = sprintf(
                __('URGENT: Your site is not correctly connected to your SANDBOX Authorize.Net account. Generate a client public key within the Authorize.Net dashboard, and paste that key into the <a href="%s" >settings page</a>. <a href="%s" target="_blank">How to connect to Authorize.Net &raquo;</a>',
                    'give-authorize'),
                admin_url('/edit.php?post_type=give_forms&page=give-settings&tab=gateways&section=authorize-net-gateway'),
                'http://docs.givewp.com/authorizenet-client-public-key'
            );

            Give()->notices->register_notice($notice);
        }

        if ( ! give_is_test_mode() &&
             $apiAccessData->liveLoginId &&
             $apiAccessData->liveTransactionKey &&
             empty($apiAccessData->liveClientPublicKey)) {
            $notice['description'] = sprintf(
                __('URGENT: Your site is not correctly connected to your LIVE Authorize.Net account. Generate a client public key within the Authorize.Net dashboard, and paste that key into the <a href="%s" >settings page</a>. <a href="%s" target="_blank">How to connect to Authorize.Net &raquo;</a>',
                    'give-authorize'),
                admin_url('/edit.php?post_type=give_forms&page=give-settings&tab=gateways&section=authorize-net-gateway'),
                'http://docs.givewp.com/authorizenet-client-public-key'
            );

            Give()->notices->register_notice($notice);
        }
    }
}
