<?php

namespace GiveAuthorizeNet\Actions;

/**
 * @since 2.0.0
 */
class SendClientPublicKeyUpdateFailedEmail
{
    /**
     * @since 2.0.0
     */
    public function __invoke()
    {
        $environment = give_is_test_mode() ? 'SANDBOX' : 'LIVE';
        $docURL = 'http://docs.givewp.com/authorizenet-client-public-key';

        $subject = sprintf(__('Urgent: update your Authorize.Net %s client key within GiveWP to continue receiving donations.',
            'give-authorize'),
            $environment);

        $body = sprintf(
            esc_html__('During a recent update to the Authorize.Net GiveWP add-on, your site switched to using a new method of connecting to Authorize.Net. Part of that update was an attempt to automatically fill the new %s credentials. For your site, that attempt failed, but the good news is that it\'s an easy fix.',
                'give-authorize') . "</br></br>" .
            esc_html__('To connect to your %s Authorize.Net account, generate a client public key within the Authorize.Net dashboard, and then paste that key into the settings page within GiveWP. See the detailed instructions at the following link:',
                'give-authorize') . "</br></br>" .
            '<a href="%s">' . esc_html__('Connecting to Authorize.Net &raquo;',
                'give-authorize') . '</a>' . "</br></br>"
            , $environment, $environment, $docURL);

        $headers = ['Content-Type: text/html; charset=UTF-8'];

        wp_mail(give_email_admin_email(), $subject, $body, $headers);
    }
}
