<?php

namespace GiveAuthorizeNet\Actions;

use Give_Authorize;
use GiveAuthorizeNet\Exceptions\InvalidCredentialsException;
use GiveAuthorizeNet\ValueObjects\AuthorizeApiResultCode;
use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;

/**
 * @since 2.0.0
 */
class GetTransactionDetails
{
    /**
     * Use this function to get detailed information about a specific transaction.
     *
     * @see https://developer.authorize.net/api/reference/index.html#transaction-reporting-get-transaction-details
     *
     * @since 2.0.0
     * @throws InvalidCredentialsException
     */
    public function __invoke(string $gatewayTransactionId)
    {
        $merchantAuthentication = (new CreateMerchantAuthentication())();

        $request = new AnetAPI\GetTransactionDetailsRequest();
        $request->setMerchantAuthentication($merchantAuthentication);
        $request->setTransId($gatewayTransactionId);

        $controller = new AnetController\GetTransactionDetailsController($request);

        $apiResponse = $controller->executeWithApiResponse(Give_Authorize::get_instance()->getApiEnv());

        if (($apiResponse != null) && ($apiResponse->getMessages()->getResultCode() == AuthorizeApiResultCode::OK)) {
            $transactionDetails = $apiResponse->getTransaction();
        } else {
            $transactionDetails = false;
        }

        return $transactionDetails;
    }
}
