<?php

namespace GiveAuthorizeNet\Actions;

use Give\Framework\PaymentGateways\Log\PaymentGatewayLog;
use Give_Authorize;
use GiveAuthorizeNet\Exceptions\InvalidCredentialsException;
use GiveAuthorizeNet\ValueObjects\AuthorizeApiResultCode;
use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;

/**
 * @since 2.0.0
 */
class GetMerchantDetails
{
    /**
     * Call this function and supply your authentication information to receive merchant details in the response. The
     * information that is returned is helpful for OAuth and Accept integrations. Generate a PublicClientKey only if
     * one is not generated or is not active. Only the most recently generated active key is returned.
     *
     * @see https://developer.authorize.net/api/reference/index.html#transaction-reporting-get-merchant-details
     *
     * @since 2.0.0
     *
     * @return false|AnetAPI\AnetApiResponseType
     * @throws InvalidCredentialsException
     */
    public function __invoke()
    {
        $merchantAuthentication = (new CreateMerchantAuthentication())();

        $request = new AnetAPI\GetMerchantDetailsRequest();
        $request->setMerchantAuthentication($merchantAuthentication);

        $controller = new AnetController\GetMerchantDetailsController($request);

        $apiResponse = $controller->executeWithApiResponse(Give_Authorize::get_instance()->getApiEnv());

        if (($apiResponse != null) && ($apiResponse->getMessages()->getResultCode() == AuthorizeApiResultCode::OK)) {
            return $apiResponse;
        } else {
            $errorMessages = $apiResponse->getMessages()->getMessage();
            PaymentGatewayLog::error(
                '[Authorize.net] Invalid response for "GetMerchantDetails" API call.',
                [
                    'Code' => $errorMessages[0]->getCode(),
                    'Donation' => $errorMessages[0]->getText(),
                ]
            );

            return false;
        }
    }
}
