<?php

namespace GiveAuthorizeNet\Actions;

use GiveAuthorizeNet\Exceptions\InvalidCredentialsException;

/**
 * @since 2.0.0
 */
class CreateMerchantPublicClientKey
{
    /**
     * @since 2.0.0
     * @throws InvalidCredentialsException
     */
    public function __invoke(): string
    {
        $merchantDetails = (new GetMerchantDetails())();

        if ( ! $merchantDetails) {
            return '';
        }

        if (give_is_test_mode()) {
            give_update_option('give_authorize_sandbox_public_client_key', $merchantDetails->getPublicClientKey());
        } else {
            give_update_option('give_authorize_public_client_key', $merchantDetails->getPublicClientKey());
        }

        return $merchantDetails->getPublicClientKey();
    }
}
