<?php

namespace GiveAuthorizeNet\Actions;

use Exception;
use GiveAuthorizeNet\DataTransferObjects\ApiAccessData;
use GiveAuthorizeNet\Exceptions\InvalidCredentialsException;
use net\authorize\api\contract\v1 as AnetAPI;

/**
 * @since 2.0.0
 */
class CreateMerchantAuthentication
{
    /**
     * @since 2.0.0
     * @throws InvalidCredentialsException
     */
    public function __invoke(): AnetAPI\MerchantAuthenticationType
    {
        $apiAccessData = ApiAccessData::fromOptions();

        try {
            /* Create a merchantAuthenticationType object with authentication details
            retrieved from $apiAccessData var */
            $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();

            if (give_is_test_mode()) {
                $merchantAuthentication->setName($apiAccessData->sandboxLoginId);
                $merchantAuthentication->setTransactionKey($apiAccessData->sandboxTransactionKey);
            } else {
                $merchantAuthentication->setName($apiAccessData->liveLoginId);
                $merchantAuthentication->setTransactionKey($apiAccessData->liveTransactionKey);
            }
        } catch (Exception $e) {
            throw new InvalidCredentialsException($e->getMessage());
        }

        return $merchantAuthentication;
    }
}
