<?php
namespace Creativesocialicon\PageSettings;

use Elementor\Controls_Manager;
use Elementor\Core\DocumentTypes\PageBase;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class Page_Settings {

	const PANEL_TAB = 'new-tab';

	public function __construct() {
		add_action( 'elementor/init', [ $this, 'bwdsi_social_icon_add_panel_tab' ] );
		add_action( 'elementor/documents/register_controls', [ $this, 'bwdsi_social_icon_register_document_controls' ] );
	}

	public function bwdsi_social_icon_add_panel_tab() {
		Controls_Manager::add_tab( self::PANEL_TAB, esc_html__( 'New Social Icon', 'bwdsi-social-icon' ) );
	}

	public function bwdsi_social_icon_register_document_controls( $document ) {
		if ( ! $document instanceof PageBase || ! $document::get_property( 'has_elements' ) ) {
			return;
		}

		$document->start_controls_section(
			'bwdsi_social_icon_new_section',
			[
				'label' => esc_html__( 'Settings', 'bwdsi-social-icon' ),
				'tab' => self::PANEL_TAB,
			]
		);

		$document->add_control(
			'bwdsi_social_icon_text',
			[
				'label' => esc_html__( 'Title', 'bwdsi-social-icon' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Title', 'bwdsi-social-icon' ),
			]
		);

		$document->end_controls_section();
	}
}
