<?php
/**
 * Plugin Name: BWD Social Icon
 * Description: BWD social icon is an Elementor plugin that has been enriched with 43+ ready-made designs. All designs are unique, eye-catchy, and customizable. More designs will come very soon stay tuned.
 * Plugin URI:  https://wppluginzone.com/social-icon-addon-for-elementor/
 * Version:     1.0
 * Author:      Best WP Developer
 * Author URI:  https://bestwpdeveloper.com/
 * Text Domain: bwdsi-social-icon
 * Elementor tested up to: 3.0.0
 * Elementor Pro tested up to: 3.7.3
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
require_once ( plugin_dir_path(__FILE__) ) . '/includes/requires-check.php';

final class Finalbwdsisocialicon{

	const VERSION = '1.0';

	const MINIMUM_ELEMENTOR_VERSION = '3.0.0';

	const MINIMUM_PHP_VERSION = '7.0';

	public function __construct() {
		// Load translation
		add_action( 'bwdsi_init', array( $this, 'bwdsi_loaded_textdomain' ) );
		// bwdsi_init Plugin
		add_action( 'plugins_loaded', array( $this, 'bwdsi_init' ) );
	}

	public function bwdsi_loaded_textdomain() {
		load_plugin_textdomain( 'bwdsi-social-icon' );
	}

	public function bwdsi_init() {
		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			// For tgm plugin activation
			add_action( 'admin_notices', 'bwdsi_addon_failed_load');
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', array( $this, 'bwdsi_admin_notice_minimum_elementor_version' ) );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', array( $this, 'bwdsi_admin_notice_minimum_php_version' ) );
			return;
		}

		// Once we get here, We have passed all validation checks so we can safely include our plugin
		require_once( 'bwdsi-boots.php' );
	}

	public function bwdsi_admin_notice_minimum_elementor_version() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'bwdsi-social-icon' ),
			'<strong>' . esc_html__( 'BWD Social Icon', 'bwdsi-social-icon' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'bwdsi-social-icon' ) . '</strong>',
			self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>' . esc_html__('%1$s', 'bwdsi-social-icon') . '</p></div>', $message );
	}

	public function bwdsi_admin_notice_minimum_php_version() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'bwdsi-social-icon' ),
			'<strong>' . esc_html__( 'BWD Social Icon', 'bwdsi-social-icon' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'bwdsi-social-icon' ) . '</strong>',
			self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>' . esc_html__('%1$s', 'bwdsi-social-icon') . '</p></div>', $message );
	}
}

// Instantiate bwdsi-social-icon.
new Finalbwdsisocialicon();
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );