<?php
namespace Creativesocialicon;

use Creativesocialicon\PageSettings\Page_Settings;
define( "BWDSI_ASFSK_ASSETS_PUBLIC_DIR_FILE", plugin_dir_url( __FILE__ ) . "assets/public" );
define( "BWDSI_ASFSK_ASSETS_ADMIN_DIR_FILE", plugin_dir_url( __FILE__ ) . "assets/admin" );

class ClassBWDSIsocialicon {

	private static $_instance = null;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function bwdsi_admin_editor_scripts() {
		add_filter( 'script_loader_tag', [ $this, 'bwdsi_admin_editor_scripts_as_a_module' ], 10, 2 );
	}

	public function bwdsi_admin_editor_scripts_as_a_module( $tag, $handle ) {
		if ( 'bwdsi_the_social_icon_editor' === $handle ) {
			$tag = str_replace( '<script', '<script type="module"', $tag );
		}

		return $tag;
	}

	private function include_widgets_files() {
		require_once( __DIR__ . '/widgets/bwdsi-social-icon.php' );
	}

	public function bwdsi_register_widgets() {
		// Its is now safe to include Widgets files
		$this->include_widgets_files();

		// Register Widgets
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\bwdsiSocialicon() );
	}

	private function add_page_settings_controls() {
		require_once( __DIR__ . '/page-settings/bwdsi-social-icon-manager.php' );
		new Page_Settings();
	}

	// Register Category
	function bwdsi_add_elementor_widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'bwdsi-social-icon-category',
			[
				'title' => esc_html__( 'BWD Social Icon', 'bwd-social-icon' ),
				'icon' => 'eicon-person',
			]
		);
	}
	public function bwdsi_all_assets_for_the_public(){
		wp_enqueue_style( 'bwdsi-fontAwesome-css', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.8.0/css/all.min.css', array(), '5.8.0', 'all' );
		$all_css_js_file = array(
            'bwdsi_step_style_css' => array('bwdsi_path_define'=>BWDSI_ASFSK_ASSETS_PUBLIC_DIR_FILE . '/css/style.css'),

        );
        foreach($all_css_js_file as $handle => $fileinfo){
            wp_enqueue_style( $handle, $fileinfo['bwdsi_path_define'], null, '1.0', 'all');
        }
	}
	public function bwdsi_all_assets_for_elementor_editor_admin(){
		$all_css_js_file = array(
            'bwdsi_social_icon_admin_icon_css' => array('bwdsi_path_admin_define'=>BWDSI_ASFSK_ASSETS_ADMIN_DIR_FILE . '/icon.css'),
        );
        foreach($all_css_js_file as $handle => $fileinfo){
            wp_enqueue_style( $handle, $fileinfo['bwdsi_path_admin_define'], null, '1.0', 'all');
        }
	}

	public function __construct() {
		// For public assets
		add_action('wp_enqueue_scripts', [$this, 'bwdsi_all_assets_for_the_public']);

		// For Elementor Editor
		add_action('elementor/editor/before_enqueue_scripts', [$this, 'bwdsi_all_assets_for_elementor_editor_admin']);
		
		// Register Category
		add_action( 'elementor/elements/categories_registered', [ $this, 'bwdsi_add_elementor_widget_categories' ] );

		// Register widgets
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'bwdsi_register_widgets' ] );

		// Register editor scripts
		add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'bwdsi_admin_editor_scripts' ] );
		
		$this->add_page_settings_controls();
	}
}

// Instantiate Plugin Class
ClassBWDSIsocialicon::instance();